//
//  GSVodVideoTableViewCell.m
//  PlayerSDKDemo
//
//  Created by 张俞 on 2023/8/3.
//  Copyright © 2023 Geensee. All rights reserved.
//

#import "GSVodVideoTableViewCell.h"
#import "GSVodPlayerBar.h"
#import "GSMenu.h"
#define TableViewHeight ([UIScreen mainScreen].bounds.size.height)

@interface GSVodVideoTableViewCell()<GSVodPlayerBarDelegate,GSVodInfoPlayerDelegate>
/// 用于显示播放视频view
@property (nonatomic, strong) VodGLView * vodView;
/// 播放工具
@property (nonatomic, strong) GSVodPlayerBar *playerBar;
/// 重试创建播放器
@property (nonatomic, strong) UIButton * retryCreatePlayerButton;

/// 关闭视频按钮
@property (nonatomic, strong) UIButton* closedVideoButton;

@property (nonatomic, strong) UIImageView * audioIconImage;

/**
 首帧耗时显示label
 */
@property (nonatomic, strong) UILabel * useTimeLabel;

@end
@implementation GSVodVideoTableViewCell
- (void)dealloc{
    NSLog(@"cell(%@) dealloc",self.reuseIdentifier);
}
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier renderMode:(GSVideoRenderMode)renderMode VideoMode:(UIViewContentMode)videoMode{
    if(self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]){
        self.contentView.backgroundColor = [UIColor blackColor];
        VodGLView * vodView = [[VodGLView alloc] initWithFrame:CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, TableViewHeight) renderMode:renderMode];
        vodView.contentMode = videoMode;
        vodView.backgroundColor = [UIColor blackColor];
        vodView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:vodView];
        self.vodView = vodView;
        
        self.audioIconImage = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"audioIcon"]];
        self.audioIconImage.frame = CGRectMake(0, TableViewHeight/4, [UIScreen mainScreen].bounds.size.width, TableViewHeight/2);
        self.audioIconImage.hidden = YES;
        [self.contentView addSubview:self.audioIconImage];
        
        UILabel * vodTitleLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 120, [UIScreen mainScreen].bounds.size.width, 44)];
        vodTitleLabel.backgroundColor = [UIColor colorWithWhite:0 alpha:0.5];
        vodTitleLabel.font = [UIFont systemFontOfSize:15];
        vodTitleLabel.textAlignment = NSTextAlignmentCenter;
        vodTitleLabel.textColor = [UIColor whiteColor];
        [self.contentView addSubview:vodTitleLabel];
        self.vodTitleLabel = vodTitleLabel;
        
        GSVodPlayerBar * playerBar = [[GSVodPlayerBar alloc] initWithFrame:CGRectMake(0, TableViewHeight - 60, [UIScreen mainScreen].bounds.size.width, 60)];
        playerBar.isPlay = NO;
        playerBar.delegate = self;
        [self.contentView addSubview:playerBar];
        self.playerBar = playerBar;
        
        self.retryCreatePlayerButton = [[UIButton alloc] initWithFrame:CGRectMake(0, TableViewHeight/2 - 100, [UIScreen mainScreen].bounds.size.width, 100)];
        self.retryCreatePlayerButton.titleLabel.textAlignment = NSTextAlignmentCenter;
        self.retryCreatePlayerButton.hidden = YES;
        [self.retryCreatePlayerButton setTitle:@"点播加载中..." forState:UIControlStateNormal];
        [self.retryCreatePlayerButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [self.contentView addSubview:self.retryCreatePlayerButton];
        
        UIButton* button = [UIButton buttonWithType:UIButtonTypeCustom];
        [button setTitle:@"关闭视频" forState:UIControlStateNormal];
        [button setTitle:@"打开视频" forState:UIControlStateSelected];
        button.layer.backgroundColor = [UIColor lightGrayColor].CGColor;
        button.layer.cornerRadius = 4.0;
        [button addTarget:self action:@selector(closedVodPlayerVideo:) forControlEvents:UIControlEventTouchUpInside];
        button.frame = CGRectMake(self.playerBar.frame.size.width - 200, self.playerBar.frame.origin.y - 70, 150, 50);
        [self.contentView addSubview:button];
        self.closedVideoButton = button;
        
        self.useTimeLabel = [[UILabel alloc] initWithFrame:CGRectMake(10, self.playerBar.frame.origin.y - 70, 200, 22)];
        self.useTimeLabel.font = [UIFont boldSystemFontOfSize:16.f];
        self.useTimeLabel.textColor = [UIColor redColor];
        [self.contentView addSubview:self.useTimeLabel];
    
    }
    return self;
}
#pragma mark -- 关闭点播视频
- (void)closedVodPlayerVideo:(UIButton *)sender{
    sender.selected = !sender.selected;
    if(sender.selected){
        self.vodInfo.isClosedVideo = YES;
        [self.vodInfo.vodObj.player closeVideo:YES];
        
    }else{
        self.vodInfo.isClosedVideo = NO;
        [self.vodInfo.vodObj.player closeVideo:NO];
    }
}
#pragma mark -- 设置点播信息
- (void)setVodInfo:(GSVodInfo *)vodInfo{
    _vodInfo = vodInfo;
    vodInfo.playerDelegate = self;
    /// 重置播放器
    [self resetPlayerBar];
    
    if(self.vodInfo.isHaveVideo){
        self.audioIconImage.hidden = YES;
    }else{
        self.audioIconImage.hidden = NO;
    }
    
    if(self.vodInfo.vodObj.player){
        // 设置点播播放器的渲染视图
        self.vodInfo.vodObj.player.mVideoView = self.vodView;
        // 渲染播放器的第一帧视频数据
        [self.vodInfo.vodObj.player renderPlayerFirstVideoData];
    }

    if(vodInfo.isCreatePlayerSuccess){
        // 播放器创建成功
        self.retryCreatePlayerButton.hidden = YES;
        if(vodInfo.isPlay){
            // 开始播放
            [self startPlay];
        }
    }else{
        // 播放器创建失败
        self.retryCreatePlayerButton.hidden = NO;
    }
    // 是否关闭点播视频
    if(self.vodInfo.isClosedVideo){
        self.closedVideoButton.selected = YES;
        [self.vodInfo.vodObj.player closeVideo:YES];
        
    }else{
        self.closedVideoButton.selected = NO;
        [self.vodInfo.vodObj.player closeVideo:NO];
    }
    self.useTimeLabel.text = [NSString stringWithFormat:@"首帧耗时:%.0f",vodInfo.firstVideoUsedTime];

}

#pragma mark -- 开始播放
- (void)startPlay{
    self.playerBar.isPlay = YES;
    [self.playerBar layoutIfNeeded];
//    [self.vodInfo.vodObj.player resume];
}
#pragma mark -- 重置播放工具栏
- (void)resetPlayerBar{
    // 工具栏
    self.playerBar.currentTime = 0;
    self.playerBar.totalTime = self.vodInfo.duration;
    [self.vodInfo.vodObj.player SpeedPlay:SPEED_NORMAL];
    [self.playerBar setValue:@"1X" forKeyPath:@"speedLabel.text"];
    self.playerBar.isPlay = NO;
    [self.playerBar layoutIfNeeded];
}
#pragma mark -- 点播播放器创建成功回调,<GSVodInfoPlayerDelegate>
- (void)onVodPlayeronInitWithDuration:(int)duration{
    self.playerBar.totalTime = duration;
    [self.playerBar layoutIfNeeded];
    self.retryCreatePlayerButton.hidden = YES;
}
#pragma mark -- 进度回调方法,<GSVodInfoPlayerDelegate>
- (void)onPosition:(int)position
{
    NSLog(@"播放 onPosition:%d %ld %p",position,(long)self.vodInfo.row,self);
    self.playerBar.currentTime = position;
}
#pragma mark -- 播放完成停止通知，<GSVodInfoPlayerDelegate>
- (void)onStop{
    NSLog(@"[VodPlayer] onStop");
    // 播放结束后，想要继续播放 需要调用OnlinePlay和resume 方法,重置播放器，播放状态会到初始状态
    [self.vodInfo.vodObj.player OnlinePlay:NO audioOnly:NO];
    [self.vodInfo.vodObj.player resume];
    
    // 播放工具栏回到初始状态
    [self.playerBar setValue:@"1X" forKeyPath:@"speedLabel.text"];
    self.playerBar.isPlay = YES;
    self.playerBar.currentTime = 0;
    [self.playerBar layoutIfNeeded];
    
    // 关闭视频按钮 回到初始状态
    self.vodInfo.isClosedVideo = NO;
    self.closedVideoButton.selected = NO;


}
#pragma mark -- 首帧耗时回调
- (void)onFirstVideoUsedTime:(double)time{
    self.useTimeLabel.text = [NSString stringWithFormat:@"首帧耗时:%.0f",time];
}

#pragma mark - GSVodPlayerBarDelegate
#pragma mark -- 设置播放或暂停
- (void)vodPlayerBar:(GSVodPlayerBar *)bar didSetPlay:(BOOL)isPlay {
    NSLog(@"[VodPlayer] didSetPlay : %d",isPlay);
    if (isPlay) {
        [self.vodInfo.vodObj.player resume];
    }else{
        [self.vodInfo.vodObj.player pause];
    }
}
#pragma mark -- 开始调整进度
- (void)vodPlayerBar:(GSVodPlayerBar *)bar beginSlide:(int)value {
    NSLog(@"[VodPlayer] beginSlide : %d",value);
    self.playerBar.isPlay = NO;
    [self.vodInfo.vodObj.player pause];

}
#pragma mark -- 快进到
- (void)vodPlayerBar:(GSVodPlayerBar *)bar didSlideToValue:(int)value {
    [self.vodInfo.vodObj.player seekTo:value];
    self.playerBar.isPlay = YES;
}

- (NSArray *)refs {
    return [NSArray arrayWithObjects:@"1X", @"1.25X", @"1.5X", @"1.75X", @"2X", @"2.5X", @"3X", @"3.5X", @"4X", nil];
}
#pragma mark -- 倍速
- (void)vodPlayerBar:(GSVodPlayerBar *)bar didClickSpeed:(UILabel *)label {
    [GSMenu setTitleFont:[UIFont systemFontOfSize:12.f]];
    NSMutableArray *items = [NSMutableArray array];
    NSArray *refs = [self refs];
    for (int i = 0; i < refs.count; i++) {
        GSMenuItem *report;
        report = [GSMenuItem menuItem:refs[i]
                                image:nil  //pure_fault
                               target:self
                               action:@selector(selectSpeed:)];
        report.tag = i;
        report.foreColor = [UIColor colorWithRed:102/255.f green:102/255.f blue:102/255.f alpha:1];
        
        [items addObject:report];
    }
    [GSMenu showMenuInView:self.contentView
                  fromRect:[self.contentView convertRect:label.frame fromView:bar]
                 menuItems:items];
}

- (void)selectSpeed:(GSMenuItem *)item {
    [self.vodInfo.vodObj.player SpeedPlay:item.tag];
    [self.playerBar setValue:self.refs[item.tag] forKeyPath:@"speedLabel.text"];
    [self.playerBar layoutIfNeeded];
}

@end
